/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap;

import java.lang.ref.WeakReference;
import java.util.Objects;
import lombok.NonNull;
import net.minecraft.class_1309;

public class PlayerHpWatcher {
    private static final WeakReference<class_1309> NULL_WEAK_REFERENCE = new WeakReference<Object>(null);
    @NonNull
    private WeakReference<class_1309> lastPlayer = NULL_WEAK_REFERENCE;
    private float lastPlayerHp = -1.0f;
    private int ignore = 0;

    public float updatePlayerHpAndGetDamage(@NonNull class_1309 player, float hp) {
        Objects.requireNonNull(player, "player is marked non-null but is null");
        float damage = this.calculateDamage(player, hp);
        this.lastPlayerHp = hp;
        return damage;
    }

    public void updatePlayerHpBypassIgnore(float hp) {
        this.lastPlayerHp = hp;
    }

    private float calculateDamage(@NonNull class_1309 player, float hp) {
        Objects.requireNonNull(player, "player is marked non-null but is null");
        if (player != this.lastPlayer.get()) {
            this.lastPlayer = new WeakReference<class_1309>(player);
            this.ignore = 1;
            return 0.0f;
        }
        if (this.ignore != 0) {
            --this.ignore;
            return 0.0f;
        }
        return this.lastPlayerHp - hp;
    }

    public void resetPlayer() {
        this.lastPlayer = NULL_WEAK_REFERENCE;
        this.lastPlayerHp = -1.0f;
    }
}

